import { CFG } from './config.js';

function allocFraction(atrPct){
  if (atrPct > CFG.ATR_BANDS.HI3) return 0.20;
  if (atrPct > CFG.ATR_BANDS.HI2) return 0.40;
  if (atrPct > CFG.ATR_BANDS.MID) return 0.80;
  return 1.00;
}

function clamp(x, lo, hi){ return Math.min(Math.max(x, lo), hi); }

function adxGain(adx){
  if (adx > CFG.TRAIL.ADX_STRONG) return 1.15;
  if (adx < CFG.TRAIL.ADX_WEAK) return 0.85;
  return 1.00;
}

export const strat = {
  sizingFromATR(atrPct){ return allocFraction(atrPct); },
  makeInitialStop(entry, atr){ return entry - CFG.SL_K * atr; },
  trailPct(atrPct, adx){
    const base = (atrPct || 0) * CFG.TRAIL.ATR_FACTOR * adxGain(adx||0);
    return clamp(base, CFG.TRAIL.MIN, CFG.TRAIL.MAX);
  }
};
